<?php

namespace Spatie\Mailcoach\Livewire\Audience;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Livewire\Component;
use Spatie\Mailcoach\Domain\Audience\Models\EmailList;
use Spatie\Mailcoach\Domain\Audience\Rules\EmailListSubscriptionRule;
use Spatie\Mailcoach\Domain\Shared\Traits\UsesMailcoachModels;

class CreateSubscriberComponent extends Component
{
    use AuthorizesRequests;
    use UsesMailcoachModels;

    public ?string $email = null;

    public ?string $first_name = null;

    public ?string $last_name = null;

    public EmailList $emailList;

    public function mount(EmailList $emailList)
    {
        $this->emailList = $emailList;
    }

    protected function rules()
    {
        return [
            'email' => ['required', config('mailcoach.audience.email_validation_rule', 'email:strict,dns'), new EmailListSubscriptionRule($this->emailList)],
            'first_name' => ['nullable', 'string'],
            'last_name' => ['nullable', 'string'],
        ];
    }

    public function saveSubscriber()
    {
        $subscriberClass = self::getSubscriberClass();

        $this->authorize('create', $subscriberClass);

        $validated = $this->validate();

        $subscriberClass::createWithEmail($validated['email'])
            ->withAttributes([
                'first_name' => $validated['first_name'],
                'last_name' => $validated['last_name'],
            ])
            ->skipConfirmation()
            ->subscribeTo($this->emailList);

        notify(__mc('Subscriber :subscriber was created.', ['subscriber' => $this->email]));

        return redirect()->route('mailcoach.emailLists.subscribers', $this->emailList);
    }

    public function render()
    {
        return view('mailcoach::app.emailLists.subscribers.create');
    }
}
