<?php

namespace Spatie\Mailcoach\Domain\Audience\Policies;

use Illuminate\Contracts\Auth\Access\Authorizable;
use Illuminate\Contracts\Auth\Authenticatable;
use Spatie\Mailcoach\Domain\Audience\Enums\SuppressionReason;
use Spatie\Mailcoach\Domain\Audience\Models\Suppression;

class SuppressionPolicy
{
    public function reactivate(Authenticatable $user, Suppression $suppression)
    {
        return $suppression->reason !== SuppressionReason::spamComplaint;
    }

    public function __call($method, $args): bool
    {
        /** @var Authorizable $user */
        $user = array_shift($args);

        return $user->can('viewMailcoach');
    }
}
