@php
    use Illuminate\Support\Arr;
    use Filament\Support\Enums\Alignment;
    use Filament\Support\Enums\VerticalAlignment;
    use Illuminate\Support\Js;

    $color = $getColor() ?? $getIconColor() ?? 'gray';
    $isInline = $isInline();
@endphp

<div
    x-data="notificationComponent({ notification: <?= Js::from($toArray()) ?> })"
    wire:key="{{ $getId() }}.notifications.{{ $getId() }}"
    x-on:close-notification.window="if ($event.detail.id == '{{ $getId() }}') close()"
    x-transition:enter-start="fi-transition-enter-start"
    x-transition:leave-end="fi-transition-leave-end"
    @class([
        'z-[9999] w-full transition duration-300',
        ...match ($isInline) {
            true => ['fi-inline'],
            false => [
                "bg-navy-bleak text-white rounded-sm py-4 px-6 max-w-sm ring-1 alert-" . $color,
            ],
        },
    ])
>
    <div
        @class([
            'flex items-start w-full gap-3',
            ...match ($isInline) {
                true => [],
                false => [
                    'rounded-xl',
                ],
            },
        ])
    >
        @if ($icon = $getIcon())
            <x-filament::icon
                :color="$getIconColor()"
                :icon="$icon"
                :size="$getIconSize()"
            />
        @endif

        <div class="grid flex-1 gap-y-1">
            @if (filled($title = $getTitle()))
                <p class="text-sm leading-5">
                    {{ str($title)->sanitizeHtml()->toHtmlString() }}
                </p>
            @endif

            @if (filled($date = $getDate()))
                <div class="mt-1">
                    {{ $date }}
                </div>
            @endif

            @if (filled($body = $getBody()))
                <p class="text-sm leading-5 font-light">
                    {{ str($body)->sanitizeHtml()->toHtmlString() }}
                </p>
            @endif

            @if ($actions = $getActions())
                <x-filament::actions
                    :actions="$actions"
                    class="mt-3"
                />
            @endif

        </div>
    </div>

    <div class="
        absolute
        pointer-events-none
        bottom-0
        h-1
        left-0
        right-0
        transform
        origin-bottom-left
        shadow-card
        {{ match($color) {
            'success' => 'bg-green',
            'error' => 'bg-red',
            'warning' => 'bg-orange',
            default => 'bg-blue'
        } }}
    " style="animation: alert-countdown var(--alert-duration, 5s) linear forwards; --alert-duration: {{ $getDuration() / 1000 }}s"></div>
</div>
