<x-mailcoach::card>
    <x-mailcoach::alert type="help">
        <div class="markup-lists">
        <p>Mailcoach can import (almost) all data to be used in a different Mailcoach instance.</p>
        <p>The import will <strong class="font-semibold">not import</strong> the following data:</p>
        <ul>
            <li>Users</li>
            <li>Individual send data</li>
            <li>Clicks / Opens / Unsubscribes (it will only export the calculated statistics)</li>
            <li>Any uploaded media</li>
        </ul>
        <p>Be sure to check your automations after import:</p>
        <ul>
            <li><strong class="font-semibold">"Send automation mail"</strong> actions will need manual adjustment to the correct Automation Mail</li>
            <li>Automations are imported <strong class="font-semibold">as paused.</strong></li>
        </ul>
        <p>Imports can always be reuploaded if something goes wrong.</p>
        </div>
    </x-mailcoach::alert>


    @if (($steps = Cache::get('import-status', [])) || $importStarted)
        <x-mailcoach::fieldset class="ml-2">
        <div class="flex flex-col gap-4" @if(! collect($steps)->where('failed', true)->count() && ! collect($steps)->keys()->contains('Cleanup')) wire:poll.1500ms @endif>
            @forelse ($steps as $name => $data)
                <p class="flex items-center gap-2">
                    @if ($data['finished'])
                        <x-mailcoach::rounded-icon size="md" type="success" icon="heroicon-s-check" />
                        <strong class="font-semibold">{{ $name }}</strong>
                        @if($data['total'])
                            <span>&mdash; {{ number_format($data['total']) }} rows</span>
                        @endif
                    @elseif ($data['failed'])
                        <x-mailcoach::rounded-icon size="md" type="error" icon="heroicon-s-x-mark" />
                        <strong class="font-semibold">{{ $name }}</strong>
                        <span> &mdash; {{ $data['message'] }}</span>
                    @else
                        <x-mailcoach::rounded-icon size="md" type="info" icon="heroicon-s-arrow-path" class="animate-spin" />
                        <strong class="font-semibold">{{ $name }}</strong>
                        <span>&nbsp;{{ round($data['progress'] * 100, 2) }}%</span>
                    @endif
                </p>
            @empty
                <p class="flex items-center gap-2">
                    <x-mailcoach::rounded-icon size="md" type="success" icon="heroicon-s-check" />
                    <strong class="font-semibold">Import queued...</strong>
                </p>
            @endforelse

            @if(!collect($steps)->where('finished', false)->where('failed', false)->count() && !collect($steps)->keys()->contains('Cleanup'))
                <div class="flex items-center gap-2">
                    <x-mailcoach::rounded-icon size="md" type="info" icon="heroicon-s-arrow-path" class="animate-spin" />
                    <strong class="font-semibold">Next step is queued...</strong>
                </div>
            @endif
        </div>
        </x-mailcoach::fieldset>

        <x-mailcoach::button wire:click.prevent="clear" :label="__mc('Start new import')" />
    @else
        <div class="flex gap-6">
            <div class="w-1/3">
                <x-filepond::upload
                    wire:model="file"
                    :acceptedFileTypes="['application/zip', 'application/octet-stream', 'application/x-zip-compressed', 'multipart/x-zip']"
                    :fileValidateTypeLabelExpectedTypes="__mc('Upload a zip file')"
                    :placeholder="__mc('Drag & Drop your file or <span class=\'filepond--label-action\'> Browse </span>')"
                />
                @error('file')
                <p class="form-error">{{ $message }}</p>
                @enderror
            </div>
            <x-heroicon-s-arrow-right class="w-6" />
            <div class="flex items-center gap-4">
                <x-mailcoach::button wire:click.prevent="import" :label="__mc('Import')" :disabled="!$file" />
            </div>
        </div>
    @endif
</x-mailcoach::card>
