<?php

namespace Spatie\Mailcoach\Domain\Automation\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Spatie\Mailcoach\Domain\Shared\Models\Concerns\UsesDatabaseConnection;
use Spatie\Mailcoach\Domain\Shared\Models\HasUuid;
use Spatie\Mailcoach\Domain\Shared\Traits\UsesMailcoachModels;

class ActionSubscriber extends Pivot
{
    use HasFactory;
    use HasUuid;
    use UsesDatabaseConnection;
    use UsesMailcoachModels;

    public $table = 'mailcoach_automation_action_subscriber';

    public $incrementing = true;

    public $timestamps = true;

    protected $casts = [
        'run_at' => 'datetime',
        'completed_at' => 'datetime',
        'halted_at' => 'datetime',
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo<\Spatie\Mailcoach\Domain\Automation\Models\Action, $this>
     */
    public function action(): BelongsTo
    {
        return $this->belongsTo(static::getAutomationActionClass());
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo<\Spatie\Mailcoach\Domain\Audience\Models\Subscriber, $this>
     */
    public function subscriber(): BelongsTo
    {
        return $this->belongsTo(static::getSubscriberClass());
    }
}
